#include <struct.h>
#include <3dengine.h>


//-------------------------------------------------------------------
//    Z-Buffer
//-------------------------------------------------------------------
DWORD CALLBACK ZBufferOnLoad(tProcParams* params)
{
  DWORD  FlagsSet = params->pApp->GetProfileInt("Plugins settings\\z3dutils\\Custom parameters\\", "Device Flags", params->pD3D->GetDeviceFlags());
  if (FlagsSet & ZBuffer)
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
  else
    return Z3D_PLUGRESULT_ENABLEPROC;
}
DWORD CALLBACK ZBufferActivate(tProcParams* params)
{  if (!params) return 0;
  params->pD3D->ChangeDeviceFlag(ZBuffer, TRUE);
  return Z3D_PLUGRESULT_REDRAW;
}

DWORD CALLBACK ZBufferDeactivate(tProcParams* params)
{  if (!params) return 0;
  params->pD3D->ChangeDeviceFlag(ZBuffer, FALSE);
  return Z3D_PLUGRESULT_REDRAW;
}

//-------------------------------------------------------------------
//    Dithering
//-------------------------------------------------------------------
DWORD CALLBACK DitheringOnLoad(tProcParams* params)
{
  DWORD  FlagsSet = params->pApp->GetProfileInt("Plugins settings\\z3dutils\\Custom parameters\\", "Device Flags", params->pD3D->GetDeviceFlags());
  if (FlagsSet & Dithering)
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
  else
    return Z3D_PLUGRESULT_ENABLEPROC;
}
DWORD CALLBACK DitheringActivate(tProcParams* params)
{  if (!params) return 0;
  params->pD3D->ChangeDeviceFlag(Dithering, TRUE);
  return Z3D_PLUGRESULT_REDRAW;
}
DWORD CALLBACK DitheringDeactivate(tProcParams* params)
{  if (!params) return 0;
  params->pD3D->ChangeDeviceFlag(Dithering, FALSE);
  return Z3D_PLUGRESULT_REDRAW;
}

//-------------------------------------------------------------------
//    Specular
//-------------------------------------------------------------------
DWORD CALLBACK SpecularHighlightOnLoad(tProcParams* params)
{
  DWORD  FlagsSet = params->pApp->GetProfileInt("Plugins settings\\z3dutils\\Custom parameters\\", "Device Flags", params->pD3D->GetDeviceFlags());
  if (FlagsSet & Specular)
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
  else
    return Z3D_PLUGRESULT_ENABLEPROC;
}
DWORD CALLBACK SpecularHighlightActivate(tProcParams* params)
{  if (!params) return 0;
  params->pD3D->ChangeDeviceFlag(Specular, TRUE);
  return Z3D_PLUGRESULT_REDRAW;
}

DWORD CALLBACK SpecularHighlightDeactivate(tProcParams* params)
{  if (!params) return 0;
  params->pD3D->ChangeDeviceFlag(Specular, FALSE);
  return Z3D_PLUGRESULT_REDRAW;
}

//-------------------------------------------------------------------
//    Fog
//-------------------------------------------------------------------
DWORD CALLBACK UseFogOnLoad(tProcParams* params)
{
  if (params->pD3D->Fog & BitEnabled)
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
  else
    return Z3D_PLUGRESULT_ENABLEPROC;
}
DWORD CALLBACK UseFogActivate(tProcParams* params)
{  if (!params) return 0;
  params->pD3D->Fog |= BitEnabled;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

DWORD CALLBACK UseFogDeactivate(tProcParams* params)
{  if (!params) return 0;
  params->pD3D->Fog &= ~BitEnabled;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    Per-Faces
//-------------------------------------------------------------------
DWORD CALLBACK PerfacerenderingOnLoad(tProcParams* params)
{
  DWORD  FlagsSet = params->pApp->GetProfileInt("Plugins settings\\z3dutils\\Custom parameters\\", "Device Flags", params->pD3D->GetDeviceFlags());
  
  params->pD3D->ChangeDeviceFlag(FlagsSet & ~(ForceSoftware), TRUE);

  if ((FlagsSet & IgnoreCustomFlags) != IgnoreCustomFlags)
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC | Z3D_PLUGRESULT_REDRAW;
  else
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_REDRAW;
}
DWORD CALLBACK PerfacerenderingActivate(tProcParams* params)
{  if (!params) return 0;
  params->pD3D->ChangeDeviceFlag(IgnoreCustomFlags, FALSE);
  return Z3D_PLUGRESULT_REDRAW;
}
DWORD CALLBACK PerfacerenderingDeactivate(tProcParams* params)
{  if (!params) return 0;
  params->pD3D->ChangeDeviceFlag(IgnoreCustomFlags, TRUE);
  return Z3D_PLUGRESULT_REDRAW;
}


//-------------------------------------------------------------------
//    SmoothTextures
//-------------------------------------------------------------------
DWORD CALLBACK SmoothTexturesOnLoad(tProcParams* params)
{
  if (params->ViewDesc->DeviceFlags & TextureFiltering)
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
  else
    return Z3D_PLUGRESULT_ENABLEPROC;
}
DWORD CALLBACK SmoothTexturesActivate(tProcParams* params)
{
  params->ViewDesc->DeviceFlags |= TextureFiltering;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK SmoothTexturesDeactivate(tProcParams* params)
{
  params->ViewDesc->DeviceFlags &= ~TextureFiltering;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    Transparency
//-------------------------------------------------------------------
DWORD CALLBACK TransparencyOnLoad(tProcParams* params)
{
  if (params->ViewDesc->DeviceFlags & AlphaBlend)
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
  else
    return Z3D_PLUGRESULT_ENABLEPROC;
}
DWORD CALLBACK TransparencyActivate(tProcParams* params)
{
  params->ViewDesc->DeviceFlags |= AlphaBlend | AlphaTest | ColorKeying;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK TransparencyDeactivate(tProcParams* params)
{
  params->ViewDesc->DeviceFlags &= ~(AlphaBlend | AlphaTest | ColorKeying);
  return Z3D_PLUGRESULT_REDRAWTHIS;
}


//-------------------------------------------------------------------
//    UseTextures
//-------------------------------------------------------------------
DWORD CALLBACK UseTexturesOnLoad(tProcParams* params)
{
  if (params->ViewDesc->DeviceFlags & UseTextures)
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
  else
    return Z3D_PLUGRESULT_ENABLEPROC;
}
DWORD CALLBACK UseTexturesActivate(tProcParams* params)
{
  params->ViewDesc->DeviceFlags |= UseTextures;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK UseTexturesDeactivate(tProcParams* params)
{
  params->ViewDesc->DeviceFlags &= ~UseTextures;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}


//-------------------------------------------------------------------
//    MultipleTexturesChrome
//-------------------------------------------------------------------
DWORD CALLBACK MultipleTexturesChromeOnLoad(tProcParams* params)
{
  if (params->ViewDesc->DeviceFlags & TexturesBlend)
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
  else
    return Z3D_PLUGRESULT_ENABLEPROC;
}
DWORD CALLBACK MultipleTexturesChromeActivate(tProcParams* params)
{
  params->ViewDesc->DeviceFlags |= TexturesBlend;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK MultipleTexturesChromeDeactivate(tProcParams* params)
{
  params->ViewDesc->DeviceFlags &= ~TexturesBlend;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    Always High Blend
//-------------------------------------------------------------------
DWORD CALLBACK AlwaysHighBlendHighChromeOnLoad(tProcParams* params)
{
  if (params->ViewDesc->DeviceFlags & AlwaysHighBlend)
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
  else
    return Z3D_PLUGRESULT_ENABLEPROC;
}
DWORD CALLBACK AlwaysHighBlendHighChromeActivate(tProcParams* params)
{
  params->ViewDesc->DeviceFlags |= AlwaysHighBlend;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK AlwaysHighBlendHighChromeDeactivate(tProcParams* params)
{
  params->ViewDesc->DeviceFlags &= ~AlwaysHighBlend;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}


//-------------------------------------------------------------------
//    Solid
//-------------------------------------------------------------------
DWORD CALLBACK SolidOnLoad(tProcParams* params)
{
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_3D)
  {
    if (params->ViewDesc->DeviceFlags & ShadePhong)
      return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
    else
      return Z3D_PLUGRESULT_ENABLEPROC;
  }
  else
  if (params->ViewDesc->Kind != Z3D_VIEWMODE_MAPPER)
  {
    if (params->ViewDesc->nFlags & Z3D_VIEWFLAG_SOLIDRENDER)
      return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
    else
      return Z3D_PLUGRESULT_ENABLEPROC;
  }
  else
    return 0;
}
DWORD CALLBACK SolidActivate(tProcParams* params)
{
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_3D)
  {
    params->ViewDesc->DeviceFlags |= ShadePhong;
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_REDRAWTHIS;
  }
  params->ViewDesc->nFlags |= Z3D_VIEWFLAG_SOLIDRENDER;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK SolidDeactivate(tProcParams* params)
{
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_3D)
  {
    params->ViewDesc->DeviceFlags &= ~ShadePhong;
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_REDRAWTHIS;
  }
  params->ViewDesc->nFlags &= ~Z3D_VIEWFLAG_SOLIDRENDER;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    Wireframe
//-------------------------------------------------------------------
DWORD CALLBACK EnabledOnLoad(tProcParams* params)
{
//  if (params->ViewDesc->Kind != Z3D_VIEWMODE_3D)
//    return 0;
  if (params->ViewDesc->WireFrame & BitEnabled)
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
  else
    return Z3D_PLUGRESULT_ENABLEPROC;
}
DWORD CALLBACK EnabledActivate(tProcParams* params)
{
  params->ViewDesc->WireFrame |=  BitEnabled;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK EnabledDeactivate(tProcParams* params)
{
  params->ViewDesc->WireFrame &= ~BitEnabled;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    Shaded
//-------------------------------------------------------------------
DWORD CALLBACK ShadedOnLoad(tProcParams* params)
{
  if (params->ViewDesc->Kind != Z3D_VIEWMODE_3D)
    return 0;
  if (params->ViewDesc->WireFrame & BitWireShaded)
    return ((params->ViewDesc->WireFrame & BitEnabled) ? Z3D_PLUGRESULT_ENABLEPROC : 0) | Z3D_PLUGRESULT_CHECKPROC;
  else
    return (params->ViewDesc->WireFrame & BitEnabled) ? Z3D_PLUGRESULT_ENABLEPROC : 0;
}
DWORD CALLBACK ShadedActivate(tProcParams* params)
{
  params->ViewDesc->WireFrame |=  BitWireShaded;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK ShadedDeactivate(tProcParams* params)
{
  params->ViewDesc->WireFrame &= ~BitWireShaded;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}


//-------------------------------------------------------------------
//    Textured
//-------------------------------------------------------------------
DWORD CALLBACK TexturedOnLoad(tProcParams* params)
{
  if (params->ViewDesc->Kind != Z3D_VIEWMODE_3D)
    return 0;
  if (params->ViewDesc->WireFrame & BitWireTextured)
    return ((params->ViewDesc->WireFrame & BitEnabled) ? Z3D_PLUGRESULT_ENABLEPROC : 0) | Z3D_PLUGRESULT_CHECKPROC;
  else
    return (params->ViewDesc->WireFrame & BitEnabled) ? Z3D_PLUGRESULT_ENABLEPROC : 0;
}
DWORD CALLBACK TexturedActivate(tProcParams* params)
{
  params->ViewDesc->WireFrame |=  BitWireTextured;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK TexturedDeactivate(tProcParams* params)
{
  params->ViewDesc->WireFrame &= ~BitWireTextured;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}


//-------------------------------------------------------------------
//    One Color
//-------------------------------------------------------------------
DWORD CALLBACK OneColorOnLoad(tProcParams* params)
{
  if (params->ViewDesc->Kind != Z3D_VIEWMODE_3D)
    return 0;
  if (params->ViewDesc->WireFrame & BitWireOneColor)
    return ((params->ViewDesc->WireFrame & BitEnabled) ? Z3D_PLUGRESULT_ENABLEPROC : 0) | Z3D_PLUGRESULT_CHECKPROC;
  else
    return (params->ViewDesc->WireFrame & BitEnabled) ? Z3D_PLUGRESULT_ENABLEPROC : 0;
}
DWORD CALLBACK OneColorActivate(tProcParams* params)
{
  params->ViewDesc->WireFrame |=  BitWireOneColor;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK OneColorDeactivate(tProcParams* params)
{
  params->ViewDesc->WireFrame &= ~BitWireOneColor;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    Color...
//-------------------------------------------------------------------
DWORD CALLBACK Color1OnLoad(tProcParams* params)
{
  if (params->ViewDesc->Kind != Z3D_VIEWMODE_3D)
    return 0;
  return (params->ViewDesc->WireFrame & BitWireOneColor) ? Z3D_PLUGRESULT_ENABLEPROC : 0;
}
DWORD CALLBACK Color1Activate(tProcParams* params)
{
  CColorDialog diag(
    (((params->ViewDesc->WireFrame & 0xFF0000)>>16)&0xFF) |
    (((params->ViewDesc->WireFrame & 0xFF)<<16)&0xFF0000) |
    ((params->ViewDesc->WireFrame & 0xFF00)),
    CC_RGBINIT | CC_FULLOPEN);
  if (IDCANCEL == diag.DoModal())
    return 0;
  params->ViewDesc->WireFrame = (params->ViewDesc->WireFrame & 0xFF000000) |
    (((diag.GetColor() & 0xFF0000)>>16)&0xFF |
    ((diag.GetColor() & 0xFF)<<16)&0xFF0000 |
    (diag.GetColor() & 0xFF00));
  return Z3D_PLUGRESULT_REDRAWTHIS;
}


//-------------------------------------------------------------------
//    Flat Shading
//-------------------------------------------------------------------
DWORD CALLBACK FlatShadingOnLoad(tProcParams* params)
{
  if (params->ViewDesc->DeviceFlags & ShadeFlat)
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
  else
    return Z3D_PLUGRESULT_ENABLEPROC;
}
DWORD CALLBACK FlatShadingActivate(tProcParams* params)
{
  params->ViewDesc->DeviceFlags |= ShadeFlat;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK FlatShadingDeactivate(tProcParams* params)
{
  params->ViewDesc->DeviceFlags &= ~ShadeFlat;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}


//-------------------------------------------------------------------
//    Perspectived
//-------------------------------------------------------------------
DWORD CALLBACK PerspectivedOnLoad(tProcParams* params)
{
  if (params->ViewDesc->Kind != Z3D_VIEWMODE_3D)
    return 0;
  if (params->ViewDesc->Perspectived)
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
  else
    return Z3D_PLUGRESULT_ENABLEPROC;
}
DWORD CALLBACK PerspectivedActivate(tProcParams* params)
{
  params->ViewDesc->Perspectived = TRUE;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK PerspectivedDeactivate(tProcParams* params)
{
  params->ViewDesc->Perspectived = FALSE;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    Reset Position
//-------------------------------------------------------------------
DWORD CALLBACK ResetPositionOnLoad(tProcParams* params)
{
  return Z3D_PLUGRESULT_ENABLEPROC;
}
DWORD CALLBACK ResetPositionActivate(tProcParams* params)
{
  params->ViewDesc->Camera.x = 0.0f;
  params->ViewDesc->Camera.y = 0.0f;
  params->ViewDesc->Camera.z = 3.0f;
  params->ViewDesc->CamTarget.x = 0.0f;
  params->ViewDesc->CamTarget.y = 0.0f;
  params->ViewDesc->CamTarget.z = 0.0f;
  params->ViewDesc->CamUpVector.x = 0.0f;
  params->ViewDesc->CamUpVector.y = 1.0f;
  params->ViewDesc->CamUpVector.z = 0.0f;
  params->ViewDesc->OffsetX  = -1.5f;
  params->ViewDesc->OffsetY  = -1.5f;
  params->ViewDesc->Zoom    = 100.0f;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    Reset Settings
//-------------------------------------------------------------------
DWORD CALLBACK ResetSettingsOnLoad(tProcParams* params)
{
  return Z3D_PLUGRESULT_ENABLEPROC;
}
DWORD CALLBACK ResetSettingsActivate(tProcParams* params)
{
  params->ViewDesc->CamFOV = 48.0f;
  params->ViewDesc->CamSlope = 0.0f;
  params->ViewDesc->Perspectived = 1;

  params->ViewDesc->PixelsPerUnit = 128;
  params->ViewDesc->DeviceFlags =
    ShadePhong | UseLighting | AlphaBlend |
    AlphaTest | ColorKeying |
    UseTextures | TexturesBlend;
  params->ViewDesc->BackgroundImageIndex = -1;
  params->ViewDesc->nFlags = Z3D_VIEWFLAG_SEETHROUGH | Z3D_VIEWFLAG_ZBUFFERED;

  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//---------------------------
//---------------------------
//  BACKGROUND
//---------------------------
//---------------------------

//-------------------------------------------------------------------
//    Mini Grid
//-------------------------------------------------------------------
DWORD CALLBACK MinigridOnLoad(tProcParams* params)
{
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_3D) return 0;
  if (params->ViewDesc->nFlags & Z3D_VIEWFLAG_NOGRID)
    return Z3D_PLUGRESULT_ENABLEPROC;
  else
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
}
DWORD CALLBACK MinigridActivate(tProcParams* params)
{
  params->ViewDesc->nFlags &= ~Z3D_VIEWFLAG_NOGRID;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK MinigridDeactivate(tProcParams* params)
{
  params->ViewDesc->nFlags |= Z3D_VIEWFLAG_NOGRID;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    Normal grid
//-------------------------------------------------------------------
DWORD CALLBACK NormalgridOnLoad(tProcParams* params)
{
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_3D) return 0;
  if (params->ViewDesc->nFlags & Z3D_VIEWFLAG_NOGRIDTENTH)
    return Z3D_PLUGRESULT_ENABLEPROC;
  else
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
}
DWORD CALLBACK NormalgridActivate(tProcParams* params)
{
  params->ViewDesc->nFlags &= ~Z3D_VIEWFLAG_NOGRIDTENTH;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK NormalgridDeactivate(tProcParams* params)
{
  params->ViewDesc->nFlags |= Z3D_VIEWFLAG_NOGRIDTENTH;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    Axis
//-------------------------------------------------------------------
DWORD CALLBACK AxisOnLoad(tProcParams* params)
{
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_3D) return 0;
  if (params->ViewDesc->nFlags & Z3D_VIEWFLAG_NOGRIDAXIS)
    return Z3D_PLUGRESULT_ENABLEPROC;
  else
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
}
DWORD CALLBACK AxisActivate(tProcParams* params)
{
  params->ViewDesc->nFlags &= ~Z3D_VIEWFLAG_NOGRIDAXIS;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK AxisDeactivate(tProcParams* params)
{
  params->ViewDesc->nFlags |= Z3D_VIEWFLAG_NOGRIDAXIS;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    Custom Color
//-------------------------------------------------------------------
DWORD CALLBACK CustomColorOnLoad(tProcParams* params)
{
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_3D) return 0;
  if (params->ViewDesc->nFlags & Z3D_VIEWFLAG_CUSTOMBACKGROUND)
    return Z3D_PLUGRESULT_ENABLEPROC | Z3D_PLUGRESULT_CHECKPROC;
  else
    return Z3D_PLUGRESULT_ENABLEPROC;
}
DWORD CALLBACK CustomColorActivate(tProcParams* params)
{
  params->ViewDesc->nFlags |= Z3D_VIEWFLAG_CUSTOMBACKGROUND;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK CustomColorDeactivate(tProcParams* params)
{
  params->ViewDesc->nFlags &= ~Z3D_VIEWFLAG_CUSTOMBACKGROUND;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    Color...
//-------------------------------------------------------------------
DWORD CALLBACK Color2OnLoad(tProcParams* params)
{
  if ((params->ViewDesc->Kind == Z3D_VIEWMODE_3D) ||
    (params->ViewDesc->nFlags & Z3D_VIEWFLAG_CUSTOMBACKGROUND))
    return Z3D_PLUGRESULT_ENABLEPROC;
  else
    return 0;
}
DWORD CALLBACK Color2Activate(tProcParams* params)
{
  DWORD* pSource = (params->ViewDesc->Kind == Z3D_VIEWMODE_3D) ? &params->ViewDesc->Background : &params->ViewDesc->nFlags;
  CColorDialog diag(
    (((*pSource & 0xFF0000)>>16)&0xFF) |
    (((*pSource & 0xFF)<<16)&0xFF0000) |
    ((*pSource & 0xFF00)),
    CC_RGBINIT | CC_FULLOPEN);
  if (IDCANCEL == diag.DoModal())
    return 0;

  *pSource = (*pSource & 0xFF000000) |
    (((diag.GetColor() & 0xFF0000)>>16)&0xFF |
    ((diag.GetColor() & 0xFF)<<16)&0xFF0000 |
    (diag.GetColor() & 0xFF00));
  return Z3D_PLUGRESULT_REDRAWTHIS;
}


//---------------------------
//---------------------------
//  BACKGROUND IMAGE
//---------------------------
//---------------------------
//-------------------------------------------------------------------
//    Show Image
//-------------------------------------------------------------------
DWORD CALLBACK ShowImageOnLoad(tProcParams* params)
{
  if (params->ViewDesc->Kind != Z3D_VIEWMODE_3D)
  {
    if (params->ViewDesc->nFlags & Z3D_VIEWFLAG_NOIMAGE)
      return ((params->ViewDesc->BackgroundImageIndex >=0) ? Z3D_PLUGRESULT_ENABLEPROC : 0);
    else
      return ((params->ViewDesc->BackgroundImageIndex >=0) ? Z3D_PLUGRESULT_ENABLEPROC : 0)
        | Z3D_PLUGRESULT_CHECKPROC;
  }
  else
  {
    if (params->ViewDesc->Background & UseBackImage)
      return ((params->ViewDesc->BackgroundImageIndex >=0) ? Z3D_PLUGRESULT_ENABLEPROC : 0)
        | Z3D_PLUGRESULT_CHECKPROC;
    else
      return ((params->ViewDesc->BackgroundImageIndex >=0) ? Z3D_PLUGRESULT_ENABLEPROC : 0);
  }
}
DWORD CALLBACK ShowImageActivate(tProcParams* params)
{
  if (params->ViewDesc->Kind != Z3D_VIEWMODE_3D)
  {
    params->ViewDesc->nFlags &= ~Z3D_VIEWFLAG_NOIMAGE;
    return Z3D_PLUGRESULT_REDRAWTHIS;
  }
  params->ViewDesc->Background |= UseBackImage;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK ShowImageDeactivate(tProcParams* params)
{
  if (params->ViewDesc->Kind != Z3D_VIEWMODE_3D)
  {
    params->ViewDesc->nFlags |= Z3D_VIEWFLAG_NOIMAGE;
    return Z3D_PLUGRESULT_REDRAWTHIS;
  }
  params->ViewDesc->Background &= ~UseBackImage;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    LoadImage
//-------------------------------------------------------------------
DWORD CALLBACK LoadImageActivate(tProcParams* params)
{
  long flags = 0;
  if (IDOK != params->sysp(
            Z3D_REQUEST_TEXTURESELECTDIALOG,
            NULL, "Choose Image to put as Background",
            &flags,
            &params->ViewDesc->BackgroundImageIndex))
    return 0;
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_3D)
  {
    if (params->ViewDesc->nFlags & Z3D_VIEWFLAG_NOIMAGE)
      params->ViewDesc->Background &= ~UseBackImage;
    else
      params->ViewDesc->Background |= UseBackImage;
  }
  params->ViewDesc->nFlags &= ~Z3D_VIEWFLAG_NOIMAGE;

  LPDIRECTDRAWSURFACE7 lpSurface = params->pD3D->Materials.Textures->GetTexture(
    params->ViewDesc->BackgroundImageIndex);

  if (!lpSurface)
    return 0;

  DDSURFACEDESC2 desc;
  desc.dwSize = sizeof(DDSURFACEDESC2);
  lpSurface->GetSurfaceDesc(&desc);

  params->ViewDesc->BackImageSize.x = desc.dwWidth;
  params->ViewDesc->BackImageSize.y = desc.dwHeight;

  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    UnloadImage
//-------------------------------------------------------------------
DWORD CALLBACK UnloadImageOnLoad(tProcParams* params)
{
  return (params->ViewDesc->BackgroundImageIndex>=0) ? Z3D_PLUGRESULT_ENABLEPROC : 0;
}

DWORD CALLBACK UnloadImageActivate(tProcParams* params)
{
  params->ViewDesc->BackgroundImageIndex = -1;
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_3D)
    params->ViewDesc->Background &= ~UseBackImage;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    Pixels per unit
//-------------------------------------------------------------------
DWORD CALLBACK PixelsperunitOnLoad(tProcParams* params)
{
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_3D)
    return 0;
  return (params->ViewDesc->BackgroundImageIndex>=0) ? Z3D_PLUGRESULT_ENABLEPROC : 0;
}
DWORD CALLBACK PixelsperunitActivate(tProcParams* params)
{
  long flags = 0;
  params->sysp(
      Z3D_REQUEST_VALUEENTER,
      NULL,
      "Image pixels per unit:",
      &params->ViewDesc->PixelsPerUnit,
      NULL);
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    Usercontrol
//-------------------------------------------------------------------
DWORD CALLBACK UsercontrolOnLoad(tProcParams* params)
{
  if (params->ViewDesc->Background & UserControl)
    return ((params->ViewDesc->BackgroundImageIndex >=0) ? Z3D_PLUGRESULT_ENABLEPROC : 0) | Z3D_PLUGRESULT_CHECKPROC;
  else
    return ((params->ViewDesc->BackgroundImageIndex >=0) ? Z3D_PLUGRESULT_ENABLEPROC : 0);
}

DWORD CALLBACK UsercontrolActivate(tProcParams* params)
{
  params->ViewDesc->Background |= UserControl;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

DWORD CALLBACK UsercontrolDeactivate(tProcParams* params)
{
  params->ViewDesc->Background &= ~UserControl;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    Rotateable
//-------------------------------------------------------------------
DWORD CALLBACK RotateableOnLoad(tProcParams* params)
{
  if (params->ViewDesc->Kind != Z3D_VIEWMODE_3D)
    return 0;
  if (params->ViewDesc->Background & RotateableImage)
    return ((params->ViewDesc->BackgroundImageIndex >=0) ? Z3D_PLUGRESULT_ENABLEPROC : 0) | Z3D_PLUGRESULT_CHECKPROC;
  else
    return ((params->ViewDesc->BackgroundImageIndex >=0) ? Z3D_PLUGRESULT_ENABLEPROC : 0);
}
DWORD CALLBACK RotateableActivate(tProcParams* params)
{
  params->ViewDesc->Background |= RotateableImage;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK RotateableDeactivate(tProcParams* params)
{
  params->ViewDesc->Background &= ~RotateableImage;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    Environment
//-------------------------------------------------------------------
DWORD CALLBACK EnvironmentOnLoad(tProcParams* params)
{
  if (params->ViewDesc->Kind != Z3D_VIEWMODE_3D)
    return 0;
  if (params->ViewDesc->Background & EnvironmentMap)
    return ((params->ViewDesc->BackgroundImageIndex >=0) ? Z3D_PLUGRESULT_ENABLEPROC : 0) | Z3D_PLUGRESULT_CHECKPROC;
  else
    return ((params->ViewDesc->BackgroundImageIndex >=0) ? Z3D_PLUGRESULT_ENABLEPROC : 0);
}
DWORD CALLBACK EnvironmentActivate(tProcParams* params)
{
  params->ViewDesc->Background |= EnvironmentMap;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
DWORD CALLBACK EnvironmentDeactivate(tProcParams* params)
{
  params->ViewDesc->Background &= ~EnvironmentMap;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}

//-------------------------------------------------------------------
//    ResetImage
//-------------------------------------------------------------------
DWORD CALLBACK ResetImageOnLoad(tProcParams* params)
{
  return ((params->ViewDesc->BackgroundImageIndex >=0) ? Z3D_PLUGRESULT_ENABLEPROC : 0);
}

DWORD CALLBACK ResetImageActivate(tProcParams* params)
{
  params->ViewDesc->BackImageOffsetX  = 0.0f,
  params->ViewDesc->BackImageOffsetY  = 0.0f,
  params->ViewDesc->BackImageZoom      = 1.0f;
  params->ViewDesc->PixelsPerUnit      = 128;
  params->ViewDesc->Background &= ~UserControl;
  return Z3D_PLUGRESULT_REDRAWTHIS;
}
